#include <stdio.h>              /* printf(), perror() */
#include <unistd.h>             /* read(), write(), chdir(), close(),
                                   gethostname() */
#include <sys/socket.h>         /* socket(), connect(), listen(), accept() */
#include <sys/stat.h>           /* stat() */
#include <arpa/inet.h>          /* inet_ntoa(), ntohs(), htons() */
#include <string.h>             /* bzero(), bcopy() */
#include <netdb.h>              /* gethostbyname() */
#include <sys/dir.h>             /* scandir() */
#include <stdlib.h>             /* malloc() */
#include <fcntl.h>              /* open() */
#include <utime.h>              /* utime() */

/*
 * Reti di calcolatori - a.a. 1998/99
 *
 *
 * Esercitazione - lato server
 *
 * Scrivere una applicazione client-server che consenta al client su una
 * certa macchina di ottenere aggiornamenti relativi ai files di una data
 * directory su una macchina remota.
 * Pi precisamente, il client scandisce la directory common_dir sulla
 * sua stessa macchina e determina il tempo dell'ultima modifica e/o
 * aggiunta tra tutti i files presenti nella directory.  Richiede quindi
 * al server l'invio di tutti i files presenti sull'host del server nella
 * directory common_dir che sono stati creati e/o modificati dopo quel
 * tempo.  Il client aggiorna quindi la propria directory in base alle
 * informazioni ricevute.
 * Se la directory common_dir del client  inizialmente vuota, il server
 * dovr inviare tutti i files della propria directory al client.
 * Varianti di questa applicazione sono possibili (da discutere con il
 * docente).
 * 
 * La comunicazione deve essere ottenuta mediante l'interfaccia socket
 * che invoca TCP/IP (connection oriented reliable transport protocol).
 * Si testi l'applicazione usando 4 macchine del laboratorio, una sulla
 * quale giri il server e tre con i processi clients.  Si usi per la porta
 * logica un valore superiore a 5000.
 */

#include "defs.h"
#define DEBUG

extern int select_dir(struct direct *);
extern int readmsg(const int, char *, const size_t);
extern int writemsg(const int, const char *, const size_t);
extern int readstat(const int, struct stat *);
extern int writestat(const int, const struct stat *);
void recv_file(const int sock, const char *name);
void rmr(const char *);
void updatedir(const int, const char *);

const char *PRGNAME;

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int sock;
	char common_dir[1024];
	struct sockaddr_in server;
	struct hostent *hp;
	
	PRGNAME = argv[0];

	if (argc < 2)
	{
		fprintf(stderr, "usage: %s <server> [common_dir]\n", PRGNAME);
		exit(1);
	}
	if (argc == 3)
		strcpy(common_dir, argv[2]);
	else
		strcpy(common_dir, ".");

	hp = gethostbyname(argv[1]);
	if (hp == NULL)
	{
		fprintf(stderr, "%s: unknown host\n", argv[1]);
		exit(1);
	}
	bzero(&server, sizeof(server));
	bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
	server.sin_port = htons(SERVER_PORT);
	server.sin_family = hp->h_addrtype;

	sock = socket(server.sin_family, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("opening socket");
		exit(1);
	}
#ifdef DEBUG
	printf("%s: socket opened\n", PRGNAME);
	printf("\tserver: %s [%s]\n", argv[1], inet_ntoa(server.sin_addr));
	printf("\tport: %d\n", ntohs(server.sin_port));
#endif

	if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0)
	{
		perror("connect");
		exit(1);
	}

	/*
	 * Scan the local common directory
	 * ordering files alphabetically
	 */
	updatedir(sock, common_dir);

	close(sock);

	exit(0);
}



/*
 * Subfunctions
 */

void
recv_file(const int sock, const char *name)
{
	int fd, bysent = 0;
	char buf[BUF_SIZE];
	struct stat filestat;
	struct utimbuf newfileutime;

	/*
	 * {Creat,Overwrite} file name with data sent by server.
	 * Change access and modification time to reflect
	 * server values.
	 */
	readstat(sock, &filestat);

#ifdef DEBUG
	printf("%s: Recv", PRGNAME);
#endif
	fd = open(name, O_WRONLY | O_CREAT | O_TRUNC, filestat.st_mode);
	while (bysent < filestat.st_size)
	{
		int byread = read(sock, buf, BUF_SIZE);
		bysent += write(fd, buf, byread);
	}
	printf(" %u bytes data file\n", bysent);
	close(fd);

	newfileutime.actime = filestat.st_atime;
	newfileutime.modtime = filestat.st_mtime;
	utime(name, &newfileutime);
}

void
rmr(const char *name)
{
	struct stat filestat;

	if (strcmp(name, ".") == 0 || strcmp(name, "..") == 0)
		return;

	stat(name, &filestat);
	if (S_ISREG(filestat.st_mode))
	{
		if (unlink(name))
			perror("removing file");
#ifdef DEBUG
		else
			printf("%s: File \"%s\" removed\n", PRGNAME, name);
#endif
	}
	else if (S_ISDIR(filestat.st_mode))
	{
		DIR *dirp = opendir(name);
		struct direct *entry;

		chdir(name);
		while ((entry = readdir(dirp)))
			rmr(entry->d_name);
		chdir("..");
		if (rmdir(name))
			perror("removing dir");
#ifdef DEBUG
		else
			printf("%s: Dir \"%s\" removed\n", PRGNAME, name);
#endif
	}
}


void
updatedir(const int sock, const char *dir)
{
	int totfile, thisfile;
	char msg[MSG_MAX];
	struct direct **namelist;

#ifdef DEBUG
	printf("%s: Scanning dir \"%s\"\n", PRGNAME, dir);
#endif
	if (chdir(dir) == -1)
	{
		perror("cd'ing");
		exit(1);
	}

	if ((totfile = scandir(".", &namelist, select_dir, alphasort)) == -1)
	{
		perror("Scanning dir");
		exit(1);
	}

	/*
	 * Send each entry to the server to check if they need to be
	 * updated.
	 */
#ifdef DEBUG
	printf("%s: %d files found\n", PRGNAME, totfile);
#endif
	thisfile = 0;
	do
	{
		char *remotename = malloc(NAME_MAX+1);
		struct stat localstat, remotestat;

		if (thisfile < totfile)
		{
			stat(namelist[thisfile]->d_name, &localstat);
			if (S_ISREG(localstat.st_mode))
				strcpy(msg, ANOTHER_FILE);
			else
				strcpy(msg, ANOTHER_DIR);
			writemsg(sock, msg, LEN_MESGS);
			writemsg(sock, namelist[thisfile]->d_name,
					sizeof(namelist[thisfile]->d_name));
		}
		else
			writemsg(sock, END_LIST, LEN_MESGS);

		readmsg(sock, msg, LEN_MESGS);

		if (strcmp(msg, STAT) == 0)
		{
			writestat(sock, &localstat);
			readmsg(sock, msg, LEN_MESGS);
			if (strcmp(msg, NEWER_FILE) == 0)
				recv_file(sock, namelist[thisfile]->d_name);
			thisfile++;
		}
		else if (strcmp(msg, NEW_DIR) == 0)
		{
			readmsg(sock, remotename, NAME_MAX+1);
			readstat(sock, &remotestat);
			if (mkdir(remotename, remotestat.st_mode))
				perror("making dir");
			updatedir(sock, remotename);
		}
		else if (strcmp(msg, NEW_FILE) == 0)
		{
			readmsg(sock, remotename, NAME_MAX+1);
			recv_file(sock, remotename);
		}
		else if (strcmp(msg, DIR_REMOVED) == 0
				|| strcmp(msg, FILE_REMOVED) == 0)
			rmr(namelist[thisfile++]->d_name);
		else if (strcmp(msg, ENTER_DIR) == 0)
			updatedir(sock, namelist[thisfile++]->d_name);
	} while (strcmp(msg, END_LIST) != 0);

	for (; thisfile < totfile; thisfile++)
		rmr(namelist[thisfile]->d_name);
	chdir("..");
}
